#!/bin/bash

setup_db()
{
    sudo -u postgres psql -c "CREATE DATABASE sae23;"
    sudo -u postgres psql -d sae23 -c "CREATE USER saeuser WITH PASSWORD 'saeuser';"
    sudo -u postgres psql -c "GRANT ALL PRIVILEGES ON DATABASE sae23 TO saeuser;"
}


if [ "$1" == "--help" ] || [ -z $1 ]; then
    printf "This script was made by Rudiger Matisse\n\n\n"
    printf "This script was made to setup the SAE23 project requirements (postgres database, python libs, flask, etc...)\n\n"
    printf "How to use:\n    --setup to install all dependances (install postgresql, python3, flask, etc...) and setup the database\n    --create-db to ONLY create the database\n    --reset-db to ONLY re-create the database by deleting it and recreating all the tables properly.\n"
    printf "\nIf you're behind a proxy, use:\n    --proxy [proxy_address]\n\n"
    exit -1
fi


if [ "$1" == "--setup" ]; then
    printf "Setting up SAE23...\n"
    sudo apt update
    sudo apt install python3 python3-pip
    sudo apt install python3-flask

    if [ "$2" == "--proxy" ]; then
        proxy_addr="$3"
        
        export http_proxy=$proxy_addr
        export https_proxy=$proxy_addr
    fi

    pip install Flask
    pip install Flask-SQLAlchemy
    pip install psycopg2-binary
    pip install flask-login
    pip install Flask-login
    pip install werkzeug

    sudo apt install postgresql
    setup_db

    mkdir sae23_project
    cd ./sae23_project
    cp ../files/* ./ -r

    exit 0
fi

if [ "$1" == "--create-db" ]; then
    setup_db
    exit 0
fi

if [ "$1" == "--reset-db" ]; then
    sudo -u postgres psql -c "DROP DATABASE sae23;"
    setup_db
    exit 0
fi

