from flask import Flask, render_template, request, redirect, url_for, session
from flask_sqlalchemy import SQLAlchemy
from werkzeug.security import generate_password_hash, check_password_hash
from flask_login import UserMixin

app = Flask(__name__, template_folder='_site')
app.secret_key = 'secret123'  # À remplacer par une vraie clé secrète en production
app.config['SQLALCHEMY_DATABASE_URI'] = 'postgresql://saeuser:saeuser@127.0.0.1:5432/sae23'
app.config['SQLALCHEMY_TRACK_MODIFICATIONS'] = False
db = SQLAlchemy(app)

class Competence(db.Model):
    id = db.Column(db.Integer, primary_key=True)
    nom = db.Column(db.String(200), nullable=False)
    niveau = db.Column(db.String(50), nullable=False)
    semestre = db.Column(db.String(10), nullable=False)

# Modèle utilisateur
class User(UserMixin, db.Model):
    id = db.Column(db.Integer, primary_key=True)
    username = db.Column(db.String(150), unique=True, nullable=False)
    password = db.Column(db.String(200), nullable=False)
    projects = db.relationship('Project', backref='owner', lazy=True)

# Modèle projet
class Project(db.Model):
    id = db.Column(db.Integer, primary_key=True)
    title = db.Column(db.String(120), nullable=False)
    user_id = db.Column(db.Integer, db.ForeignKey('user.id'), nullable=False)


@app.route('/')
def home():
    return render_template('index.html', title='Home')

@app.route('/competences_sql')
def comp_sql():
    if 'username' in session:
        competences = Competence.query.all()
        return redirect(url_for('comp_sql_admin'))
    competences = Competence.query.all()
    return render_template('competences_sql.html', title='Competences', competences=competences)

@app.route('/competences_sql_ADMIN')
def comp_sql_admin():
    if 'username' in session:
        competences = Competence.query.all()
        return render_template('competences_sql_ADMIN.html', title='Competences', competences=competences)
    return redirect(url_for('portal'))

@app.route('/ajouter', methods=['POST'])
def ajouter():
    if 'username' not in session:
        return redirect(url_for('portal'))
    nom = request.form['nom']
    niveau = request.form['niveau']
    semestre = request.form['semestre']
    competence = Competence(nom=nom, niveau=niveau, semestre=semestre)
    db.session.add(competence)
    db.session.commit()
    return redirect(url_for('comp_sql_admin'))



@app.route('/supprimer/<int:id>')
def supprimer(id):
    competence = Competence.query.get(id)
    if 'username' not in session:
        return redirect(url_for('portal'))
    if competence:
        db.session.delete(competence)
        db.session.commit()
    return redirect(url_for('comp_sql_admin'))



@app.route('/portal')
def portal():
    if 'username' in session:
        return redirect(url_for('comp_sql_admin'))
    return redirect(url_for('login'))

@app.route('/register', methods=['GET', 'POST'])
def register():
    if request.method == 'POST':
        username = request.form['username']
        password = generate_password_hash(request.form['password'])
        if User.query.filter_by(username=username).first():
            return 'Utilisateur déjà existant'
        new_user = User(username=username, password=password)
        db.session.add(new_user)
        db.session.commit()
        return redirect(url_for('portal'))
    return render_template('register.html')

@app.route('/login', methods=['GET', 'POST'])
def login():
    if request.method == 'POST':
        user = User.query.filter_by(username=request.form['username']).first()
        if user and check_password_hash(user.password, request.form['password']):
            session['username'] = user.username
            return redirect(url_for('comp_sql_admin'))
        return redirect(url_for('register'))
    return render_template('login.html')

@app.route('/logout')
def logout():
    session.pop('username', None)
    return redirect(url_for('home'))



if __name__ == '__main__':
    app.run(host='localhost', port=5000)
